<?php 
    require_once "header.php";
    if (isset($_SESSION["user"])) {
        header("Location: index.php");
        exit();
    }
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Regestration Form</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="stylesheet" href="style.css">
</head>
<body>
    <div class="form-container">
        <div class="form-header">
            <h1>Create Account</h1>
            <p>Please fill in your information to create an account</p>
        </div>
        <?php 
            if (isset($_POST["submit"])) {
                $fullname = trim(htmlspecialchars($_POST["fullname"]));
                $email = filter_var($_POST["email"], FILTER_SANITIZE_EMAIL);
                $password = $_POST["password"];
                $repeat_password = $_POST["repeat_password"];

                $err = array();

                // Validate Values
                if (empty($fullname) OR empty($email) OR empty($password) OR empty($repeat_password)) {
                    array_push($err, "All fields are required.");
                }
                if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    array_push($err, "Email is not valid.");
                }
                if (strlen($password) < 8) {
                    array_push($err, "Password must be at least 8 characters long.");
                }
                if ($password !== $repeat_password) {
                    array_push($err, "Password does not match.");
                }
                if (preg_match('/[<>"]/', $fullname)) {
                    array_push($err, "Full name contains invalid characters.");
                }

                require_once "database.php";
                $sql = "SELECT * FROM users WHERE email = ?";
                $stmt = mysqli_prepare($conn, $sql);
                mysqli_stmt_bind_param($stmt, "s", $email);
                mysqli_stmt_execute($stmt);
                $result = mysqli_stmt_get_result($stmt);
                $rowCount = mysqli_num_rows($result);
                if ($rowCount > 0) {
                    array_push($err, "Email already exists.");
                }

                if (count($err) > 0) {
                    foreach ($err as $item) {
                        echo "<div class='alert alert-danger'>" . $item . "</div>";
                    }
                } else {
                    $passwordHash = password_hash($password, PASSWORD_DEFAULT);
                    $sql = "INSERT INTO users (full_name, email, password) VALUES (?, ?, ?)";
                    $stmt = mysqli_stmt_init($conn);
                    $prepareStmt = mysqli_stmt_prepare($stmt, $sql);
                    if ($prepareStmt) {
                        mysqli_stmt_bind_param($stmt, "sss", $fullname, $email, $passwordHash);
                        mysqli_stmt_execute($stmt);
                        echo "<div class='alert alert-success'>Registration Successfull. <a href='login.php'>Login Here</a></div>";
                    } else{
                        die("Something went wrong");
                    }
                    
                }
            }
        ?>
       <form action="registration.php" method="post">
        <div class="form-group">
            <input type="text" class="form-control" name="fullname" placeholder="Full Name">
        </div>
        <div class="form-group">
            <input type="email" class="form-control" name="email" placeholder="Email Address">
        </div>
        <div class="form-group">
            <div class="password-field position-relative">
                <input type="password" class="form-control" name="password" placeholder="Password" id="password">
                <i class="bi bi-eye-slash password-toggle position-absolute top-50 end-0 translate-middle-y me-3" data-target="password"></i>
            </div>
        </div>
        <div class="form-group">
            <div class="password-field position-relative">
                <input type="password" class="form-control" name="repeat_password" placeholder="Repeat Password" id="repeat_password">
                <i class="bi bi-eye-slash password-toggle position-absolute top-50 end-0 translate-middle-y me-3" data-target="repeat_password"></i>
            </div>
        </div>
        <div class="form-btn">
            <input type="submit" class="btn btn-primary" value="Register" name="submit">
        </div>
       </form>
       
       <script src="script.js"></script>
       <div class="form-footer">
            <p>Already registered? <a href="login.php">Login Here</a></p>
       </div>
    </div>
</body>
</html>